#pragma once
//ESTRUCTURAS EXPUESTAS AL EXTERIOR
#include "clases_infobinario.h"
#include "clases_estimadores.h"
#include "clases_distorsion.h"

//Esta estructura indica si grupos de coordenadas se tratan de manrea conjunta en lo que respecta a la consideración de residuos grandes,
//por ejemplo en la asignación de pesos a la observación de cara al ajuste.
typedef struct{
	uint8m xy;	//Un residuo grande en una de las fotocoordenadas x o y afecta tambien a la otra coordenada.
	uint8m XY;	//X e Y de los puntos de apoyo
	uint8m planiZ; //XY por una parte y Z por otra en los puntos de apoyo
} EstimacionConjuntas;

typedef struct{
	sint8m im;	//>0: número de cifras significativas; 0: número fijo de decimales. Deducir
	sint8m p;	//<0: número fijo de decimales. El valor indicado menos 1.
	sint8m gps;
	sint8m ins;
} AjbloqueDecimales;

#define MASK_SalidaAjbloque_F1 0x3F3F
#define MASK_SalidaAjbloque_F2 0x3F0F
#define MASK_SalidaAjbloque_FDigi 0x1F
#define MASK_SalidaAjbloque_FIMaster 0xF
#define MASK_SalidaAjbloque_InfR 0x3F
#define MASK_SalidaAjbloque_InfP 0x1FF
#define MASK_SalidaAjbloque_StdR 1
#define MASK_SalidaAjbloque_StdP 0xFF

#define FICH_res 0
#define FICH_inc 1
#define FICH_respdf 2
#define FICH_std 3
#define FICH_grares 5
#define FICH_ajs 8
#define FICH_ori 9
#define FICH_xml 10
#define FICH_Digi 11
#define FICH_oe 12
#define FICH_Imaster 13
#define FICH_inf 16
#define FICH_html 17
#define FICH_bnf 18
#define FICH_pdf 19

#define FICH_ajsint 24
#define FICH_intpdf 25
#define FICH_intgra 26
#define FICH_intini 27
#define FICH_intcmr 28
#define FICH_intDigi 29

#define FICH2_difint 0

typedef struct{
	struct{
		unsigned res:1;	//residuos No se esccribe
		unsigned inc:1;	//incrementos a los valores aproximados No se escribe
		unsigned respdf:1;
		unsigned std:1;
		unsigned log:1;	//unused by this function
		unsigned grares:1;
		unsigned:2;
		unsigned ajs:1;
		unsigned ori:1;
		unsigned xml:1;
		unsigned Digi:1;
		unsigned oe:1;
		unsigned Imaster:1;
		unsigned:2;
		/** **/
		unsigned inf:1;
		unsigned html:1;
		unsigned bnf:1;
		unsigned pdf:1;
		unsigned:4;
		unsigned intint:1;
		unsigned intpdf:1;
		unsigned intgra:1;	//aún no está programado
		unsigned intini:1;
		unsigned intcmr:1;
		unsigned intDigi:1;
		unsigned:2;
	}ficheros;
	struct{
		/*u8int idioma; //255: igual que el principal
		bint rel_paths;*/	//Escribir rutas de los ficheros relativas, para los fichero de salida que almacenen esa información. Ahora, sólo el bnf
		unsigned idioma:8;
		unsigned rel_paths:8;
		unsigned: 16;
		char16_t uniim[6];	//Si no hay fichero de orientación interna o si este no incluye una transformación previa, unif
		char16_t unif[6];	//se copiará en uniim (por tanto uniim no se usa). En caso contrario se emplea uniim,
		char16_t unit[6];	// mientras que unif sólo se usará para los resultados de la autocalibración, si hay.
		AjbloqueDecimales decres;
		AjbloqueDecimales decajs;
		sint8m decrot;
	} general;
	struct{
		uint8m nmin;
		uint8m modo;
		bool8 brev;
	} pares_pasadas;
	struct{
		uint8m files;	//1: rel, 2: abs, 4: abs2, 8: mod, 16: patb .f indiv.
		char16_t* rutarel;
		char16_t* rutaf;
		float px;
		float py;
	} fich_Digi;
	struct{
		uint8m files;	//1: ext, 2: pairlist, 4: rel, 8: .imc indiv.
		char16_t* rutarel;
		char16_t* rutaf;
	} fich_Imaster;
#define AJ_INFR_Fotogramas 1	//Residuos
#define AJ_INFR_Apoyo 2
#define AJ_INFR_Control 8
#define AJ_INFR_GpsIns 4
#define AJ_INFR_Distribucion 0x10
#define AJ_INFR_Elevados 0x20
#define AJ_INFP_ParCentros 1
#define AJ_INFP_ParPuntos 2
#define AJ_INFP_ParGrupos 4
#define AJ_INFP_MatricesRot 8
#define AJ_INFP_PrecCentros 0x10
#define AJ_INFP_PrecPuntos 0x20
#define AJ_INFP_PrecGrupos 0x40
#define AJ_INFP_PrecCentrosTodos 0x80
#define AJ_INFP_PrecPuntosTodos 0x100
	struct{
		unsigned infR:16;
		unsigned infP:16;
	} fich_inf;
#define AJ_STDR_Distribucion 1
#define AJ_STDR_Fotogramas 2	//Redundancias parciales
#define AJ_STDR_Apoyo 4
#define AJ_STDR_GpsIns 8
#define AJ_STDP_PrecCentros 1
#define AJ_STDP_PrecPuntos 2
#define AJ_STDP_PrecGrupos 4
#define AJ_STDP_CovCentros 8
#define AJ_STDP_CorrCentros 0x10
#define AJ_STDP_CovPuntos 0x20
#define AJ_STDP_CorrPuntos 0x40
#define AJ_STDP_CorrCentrosTodos 0x80	//ccpp con puntos en común
	struct{
		unsigned stdR:16;
		unsigned stdP:16;
	} fich_std;
	struct{
		unsigned xxx:16;	//unused
	} fich_pdf;
	struct{
		Handler hwnd;			//Para ir dibujando mientras se calcula, para cálculos grandes.
		uint8m ConfigDibujo;	//byte0: si se dibuja con los valores aproximados; byte1: si se dibuja con el resultado del ajuste alterno
		char16_t** configs_main; //Ficheros con las configuraciones, para leer en tiempo de ejecución e incluir en el gráfico
		char16_t** configs_residuos;
	} fich_dibujo;
} AjbloqueConfigSalida;

static inline bint hay_residuos(AjbloqueConfigSalida *S){return S->fich_inf.infR!=0;}
static inline bint hay_avisos(AjbloqueConfigSalida *S){return (S->fich_inf.infR&0x0021 || S->fich_inf.infP&0021);}
static inline bint hay_parametros(AjbloqueConfigSalida *S){return (S->fich_inf.infP&0x000F)!=0;}
static inline bint hay_precisiones(AjbloqueConfigSalida *S){return (S->fich_inf.infP&0x0070)!=0;}
static inline bint hay_precisionesstd(AjbloqueConfigSalida *S){return (S->fich_std.stdP&7)!=0;}
static inline bint hay_matricesstd(AjbloqueConfigSalida *S){return (S->fich_std.stdP&0170)!=0;}

/*Codes returned by calcula_trabajo_absoluta. In addition to those defined here
the function may also return
	-1 (AT_ESC): El usuario ha pulsado la tecla esc
	-2 (AT_NOMEM): Memoria insuficiente.
*/
enum ATCalculaAbsolutaCodes{
	ATmainabsoluta_OK=0,
	ATmainabsoluta_UnknownError=-10,
	ATmainabsoluta_NadaqueCalcular=1,		//No hay nada que calcular
	ATmainabsoluta_error_ficherof,		//Error en la lectura del fichero de fotogramas
	ATmainabsoluta_error_ficheroint,		//Error en la lectura del fichero de interna
	ATmainabsoluta_error_ficheroapr,		//Error en la lectura del fichero de valores aproximados
	ATmainabsoluta_error_ficheroapy,		//Error en la lectura del fichero de apoyo
	ATmainabsoluta_error_ficherogps,		//Error en la lectura del fichero de GPS
	ATmainabsoluta_internamala,			//El fichero de interna no se corresponde, por mucho, con el fichero de fotogramas

	ATmainabsoluta_demo_notallowed,	//En la versión demo. Sobrepasado el límite de fotogramas
	ATmainabsoluta_fewpoints,				//Puntos insuficientes para calcular (menos de 3 puntos)
	ATmainabsoluta_bad,						//Error que no permite calcular (p. ej., un punto fuera de la Tierra);
	ATmainabsoluta_error_ajuste,			//Error en el ajuste del bloque
	ATmainabsoluta_fewcontrol_gps,		/*Se ha indicado fichero de apoyo o de GPS pero hay insuficientes puntos
						de unos u otros para definir un sistema de coordenadas 3D. Normalmente
						se debe a que se indica el fichero que no es o a una diferencia en los nombres
						(p.ej.  213 frente a 00213).
						Si la bandera APARAMS_flags0_Semilibre está a 1 se ignora esta circunstancia
						y el ajuste continua en un sistema total o parcialmente arbitrario. Por tanto
						si APARAMS_flags0_Semilibre está a 1 la función nunca devolverá este código.*/

	//>=100: El cálculo se terminó correctamente, pero hubo algún error
	ATmainabsoluta_minorerr_unknown=100,	//Error desconocido
	ATmainabsoluta_minorerr_write,				//Error en la escritura de algún fichero de resultados
};
